import { View, Text, StyleSheet, TouchableOpacity } from 'react-native';
import React from 'react';
import dpr from '../../Utilities/CustomStyleAttribute/dpr';
import { searchFilterStyles } from '../SearchFilter1/searchFilter1Style';
import FilterIcon from '../../../assets/svgs/filter/filter.svg';
import GridViewIcon from '../../../assets/svgs/filter/gridView.svg';
import ListViewIcon from '../../../assets/svgs/filter/listView.svg';
import { useSelector } from 'react-redux';
import SelectInput from '../../../src/components/CustomInput/SelectInput/SelectInput';
import DownArrowFill from '../../../assets/svgs/downArrowFill.svg';
import useLangTranslation from '../../../hooks/useLangTranslation';
import CustomSVG from '../../../src/components/CustomSVG/CustomSVG';

const GrigconSize = dpr(26);
const ListconSize = dpr(35);
const FilterComponent = (props) => {
    const { trans } = useLangTranslation();
    const {
        setListView,
        listView,
        setFilterModal,
        sortByRef,
        sortBy,
        sortByArray,
    } = props;
    const { loading } = useSelector((state) => state.searchProducts);

    return (
        <>
            <View style={searchFilterStyles.filterContainer}>
                <TouchableOpacity
                    disabled={loading}
                    style={searchFilterStyles.filterBtnCont}
                    onPress={() => setFilterModal(true)}
                >
                    <CustomSVG svgIcon={FilterIcon} height={dpr(14)} width={dpr(14)} />
                    <Text style={searchFilterStyles.filrerText}>
                        {trans('Filter')}
                    </Text>
                </TouchableOpacity>
                <SelectInput
                    style={styles.dropdown1BtnStyle}
                    placeholder={trans("Sort By: {{x}}", { x: sortBy.name })}
                    onPress={() => sortByRef.current?.snapToIndex(0)}
                    title={sortByArray?.name}
                    icon={<CustomSVG svgIcon={DownArrowFill} fill={'#2C2C2C'} />}
                />
                <TouchableOpacity
                    style={searchFilterStyles.gridIcon}
                    onPress={() => setListView(false)}
                >
                    <CustomSVG svgIcon={GridViewIcon}
                        height={GrigconSize}
                        width={GrigconSize}
                        fill={listView ? '#AFAFAF' : '#2C2C2C'}
                    />
                </TouchableOpacity>
                <TouchableOpacity onPress={() => setListView(true)}>
                    <CustomSVG svgIcon={ListViewIcon}
                        height={ListconSize}
                        width={ListconSize}
                        fill={!listView ? '#AFAFAF' : '#2C2C2C'}
                    />
                </TouchableOpacity>
            </View>
        </>
    );
};

export default FilterComponent;

const styles = StyleSheet.create({
    dropdown1BtnStyle: {
        width: dpr('wf') - dpr(220),
        height: dpr(40),
        backgroundColor: '#FFF',
        borderRadius: dpr(4),
        borderWidth: 1,
        borderColor: '#DFDFDF',
    },
});
